/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.objects.fluids.capability;

import javax.annotation.Nullable;
import net.dries007.tfc.objects.fluids.capability.IFluidHandlerSidedCallback;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public class FluidHandlerSided
implements IFluidHandler {
    private final IFluidHandlerSidedCallback callback;
    private final IFluidHandler handler;
    private final EnumFacing side;

    public FluidHandlerSided(IFluidHandlerSidedCallback callback, IFluidHandler handler, EnumFacing side) {
        this.callback = callback;
        this.handler = handler;
        this.side = side;
    }

    public IFluidTankProperties[] getTankProperties() {
        return this.handler.getTankProperties();
    }

    public int fill(FluidStack resource, boolean doFill) {
        if (this.callback.canFill(resource, this.side)) {
            return this.handler.fill(resource, doFill);
        }
        return 0;
    }

    @Nullable
    public FluidStack drain(FluidStack resource, boolean doDrain) {
        if (this.callback.canDrain(this.side)) {
            return this.handler.drain(resource, doDrain);
        }
        return null;
    }

    @Nullable
    public FluidStack drain(int maxDrain, boolean doDrain) {
        if (this.callback.canDrain(this.side)) {
            return this.handler.drain(maxDrain, doDrain);
        }
        return null;
    }
}

